<?php

function botRequest($method,$data=[]){

    $ch = curl_init(API_URL.$method);

    curl_setopt($ch,CURLOPT_POST,true);
    curl_setopt($ch,CURLOPT_POSTFIELDS,$data);
    curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);

    $response = curl_exec($ch);

    if(curl_errno($ch)){
        error_log(curl_error($ch));
    }

    curl_close($ch);

    return $response;
}

function sendMessage($chat_id,$text){
    return botRequest("sendMessage",[
        "chat_id"=>$chat_id,
        "text"=>$text,
        "parse_mode"=>"HTML"
    ]);
}

function loadJson($file){
    if(!file_exists($file)){
        return [];
    }

    $data = json_decode(file_get_contents($file),true);
    return $data ? $data : [];
}

function saveJson($file,$data){
    file_put_contents(
        $file,
        json_encode($data,JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE),
        LOCK_EX
    );
}